import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors
floor_color = "lightgrey"
passenger_color = "blue"
elevator_available_color = "green"
elevator_full_color = "red"

# Define floor positions and sizes
floor_height = 1
floor_width = 8
floor_positions = [(0, i * floor_height) for i in range(5)]

# Define passenger positions
passenger_positions = {
    'p0': (0.5, 1),
    'p1': (0.5, 3),
    'p2': (0.5, 0),
    'p3': (1.0, 0),
    'p4': (1.0, 3),
    'p5': (1.0, 1)
}

# Define elevator positions
elevator_positions = {
    'fast0': (6.5, 0),
    'fast1': (7.0, 0),
    'slow0-0': (6.5, 0),
    'slow1-0': (6.5, 2)
}

# Draw floors
for i, (x, y) in enumerate(floor_positions):
    ax.add_patch(patches.Rectangle((x, y), floor_width, floor_height, edgecolor='black', facecolor=floor_color))
    ax.text(x + 0.1, y + 0.5, f'floor_{i}', verticalalignment='center', fontsize=10, color='black')

# Draw passengers
for p_id, (x, y) in passenger_positions.items():
    ax.add_patch(patches.Rectangle((x, y), 0.4, 0.4, edgecolor='black', facecolor=passenger_color))
    ax.text(x + 0.2, y + 0.2, p_id, fontsize=8, color='white', ha='center', va='center')

# Draw elevators
elevator_status = {
    'fast0': '0/2',
    'fast1': '0/2',
    'slow0-0': '0/1',
    'slow1-0': '0/1'
}

for e_id, (x, y) in elevator_positions.items():
    status = elevator_status[e_id]
    color = elevator_available_color if '0' in status else elevator_full_color
    ax.add_patch(patches.Rectangle((x, y), 0.4, 0.4, edgecolor='black', facecolor=color))
    ax.text(x + 0.2, y + 0.2, f'{e_id}\n{status}', fontsize=8, color='white', ha='center', va='center')

# Create legend
legend_patches = [
    patches.Patch(color=elevator_available_color, label='Elevator Available'),
    patches.Patch(color=elevator_full_color, label='Elevator Full')
]
plt.legend(handles=legend_patches, loc='upper right')

# Set limits and hide axes
ax.set_xlim(-1, floor_width + 1)
ax.set_ylim(-1, 5 * floor_height)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_31.png')

# Show the plot
plt.show()
# VERIFICATION FAILED:
# Missing elevators on floor_0 and passengers on floor_1.
